/** 日期格式與有效日期之檢查 PS:tdate(日期);
 * Date format check.(ex:YYYY/MM/DD)
 */
function IsCheckDate(tdate, format){
	switch (format) {
		case "S102": // yyyy.mm.dd 
			if( !tdate.match("^[0-2][0-9][0-9][0-9][.][0-1]?[0-9][.][0-3]?[0-9]$") ) return false;
			var dateArray = tdate.split(".");
			var chdate = new Date(dateArray[0], dateArray[1]-1, dateArray[2]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[0]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[1]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[2]) )) return false;
			break;
		case "S104": // dd.mm.yyyy 
			if( !tdate.match("^[0-3]?[0-9][.][0-1]?[0-9][.][0-2][0-9][0-9][0-9]$") ) return false;
			var dateArray = tdate.split(".");
			var chdate = new Date(dateArray[2], dateArray[1]-1, dateArray[0]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[2]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[1]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[0]) )) return false;
			break;
		case "S023": // yyyy-mm-dd 
			if( !tdate.match("^[0-2][0-9][0-9][0-9][-][0-1]?[0-9][-][0-3]?[0-9]$") ) return false;
			var dateArray = tdate.split("-");
			var chdate = new Date(dateArray[0], dateArray[1]-1, dateArray[2]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[0]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[1]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[2]) )) return false;
			break;
		case "S105": // dd-mm-yyyy 
			if( !tdate.match("^[0-3]?[0-9][-][0-1]?[0-9][-][0-2][0-9][0-9][0-9]$") ) return false;
			var dateArray = tdate.split("-");
			var chdate = new Date(dateArray[2], dateArray[1]-1, dateArray[0]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[2]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[1]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[0]) )) return false;
			break;
		case "S110": // mm-dd-yyyy 
			if( !tdate.match("^[0-1]?[0-9][-][0-3]?[0-9][-][0-2][0-9][0-9][0-9]$") ) return false;
			var dateArray = tdate.split("-");
			var chdate = new Date(dateArray[2], dateArray[0]-1, dateArray[1]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[2]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[0]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[1]) )) return false;
			break;
		case "S103": // dd/mm/yyyy 
			if( !tdate.match("^[0-3]?[0-9][/][0-1]?[0-9][/][0-2][0-9][0-9][0-9]$") ) return false;
			var dateArray = tdate.split("/");
			var chdate = new Date(dateArray[2], dateArray[1]-1, dateArray[0]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[2]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[1]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[0]) )) return false;
			break;
		case "S101": // mm/dd/yyyy 
			if( !tdate.match("^[0-1]?[0-9][/][0-3]?[0-9][/][0-2][0-9][0-9][0-9]$") ) return false;
			var dateArray = tdate.split("/");
			var chdate = new Date(dateArray[2], dateArray[0]-1, dateArray[1]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[2]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[0]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[1]) )) return false;
			break;
		case "S112": // yyyymmdd 
			if( !tdate.match("^[0-2][0-9][0-9][0-9][0-1]?[0-9][0-3]?[0-9]$") ) return false;
			var dateAry1 = parseInt(tdate.substr(0,4)),
				dateAry2 = parseInt(tdate.substr(4,2)),
				dateAry3 = parseInt(tdate.substr(6,2));
			var chdate = new Date(dateAry1, dateAry2-1, dateAry3);
			if (( Number(chdate.getFullYear()) != Number(dateAry1) ) || 
				( Number(chdate.getMonth()) != Number(dateAry2-1) ) || 
				( Number(chdate.getDate()) != Number(dateAry3) )) return false;
			break;
		case "S111": // yyyy/mm/dd 
		default:
			if( !tdate.match("^[0-2][0-9][0-9][0-9][/][0-1]?[0-9][/][0-3]?[0-9]$") ) return false;
			var dateArray = tdate.split("/");
			var chdate = new Date(dateArray[0], dateArray[1]-1, dateArray[2]);
			if (( Number(chdate.getFullYear()) != Number(dateArray[0]) ) || 
				( Number(chdate.getMonth()) != Number(dateArray[1]-1) ) || 
				( Number(chdate.getDate()) != Number(dateArray[2]) )) return false;
			break;
	}
	

	return true;
}