/** CSWEB ajax參數化函式
 *  CSWEB ajax parameterized function
 *
 *	type:string(get/post/file)
 *	pary:Set object/json string
 *	{
 *		cwtp:open flag
 *		urlstr:full url(Optional)
 *		phpstr:php path url(Optional)
 *		para:system parameters object(Optional)
 *		get:get url pass parameters string or array object id(Optional)
 *		[
 *			{
 *				type:pass parameters type(str/para/val/html/attr)
 *				name:pass parameters name(type:str/para/val/html/attr)
 *				val:pass parameters value(type:str/para/attr)
 *				id:html object id(type:val/html/attr)
 *			}
 *		]
 *		poststr:post url pass parameters string(Optional)
 *		post:post url pass parameters object(Optional)
 *		[
 *			{
 *				type:pass parameters type(form/str/para/val/html/attr)
 *				name:pass parameters name(type:form/str/para/val/html/attr)
 *				val:pass parameters value(type:form/str/para/attr)
 *				id:html object id(type:form/val/html/attr)
 *			}
 *		]
 *		file:upload file pass parameters object(Optional)
 *		[
 *			{
 *				id:html object id
 *				name:pass parameters name
 *			}
 *		]
 *		aytp:asynchronous transmission switch
 *		alng:outer loading screen light box object(func name:loading_create,loading_close)
 *		slng:inner loading screen light box object(func name:loading_create,loading_close)
 *		abef:beforeSend function execute object
 *		{
 *			type:execute type(load/func/egjq/rstr/tmsg)
 *			id:html load id string(type:load)
 *			name:js function name string(type:load)
 *			para:execute object(type:func/egjq)
 *		}
 *		asuc:success function execute object
 *		{
 *			type:execute type(load/func/egjq/rstr/tmsg)
 *			id:html load id string(type:load)
 *			name:js function name string(type:load)
 *			para:execute object(type:func/egjq)
 *		}
 *		aerr:error function execute object
 *		{
 *			type:execute type(load/func/egjq/rstr/tmsg)
 *			id:html load id string(type:load)
 *			name:js function name string(type:load)
 *			para:execute object(type:func/egjq)
 *		}
 *		acom:complete function execute object
 *		{
 *			type:execute type(load/func/egjq/rstr/tmsg)
 *			id:html load id string(type:load)
 *			name:js function name string(type:load)
 *			para:execute object(type:func/egjq)
 *		}
 *	}
 *	tobj:$(this)
 */
function csweb_ajax_basic(type, pary, tobj){
	var gustr = '',pustr = '',afor = [],pdata = new FormData(),fdata = new FormData();
	if(isck_JSON(pary)) pary = JSON.parse(pary);
	if((!isck_OBJECT(pary)) || (!pary.cwtp) ||
	   (!isck_STRING(pary.urlstr,'Y') && !isck_STRING(pary.phpstr,'Y'))) return;
	if(type == 'get' || type == 'post'){
		gustr = csweb_ajax_getstr(pary, tobj);
		if(type == 'post') pustr = csweb_ajax_poststr('str', pary, tobj);
		if(isck_OBJECT(pary.alng) && typeof loading_create == 'function') loading_create(pary.alng, [], tobj);
		if(pary.aytp) $.ajaxSetup({async:false});
		$.ajax({
			url: gustr, type: type, data: pustr,
			beforeSend: function(){/* 開始前執行 */
				if(isck_OBJECT(pary.abef)) csweb_ajax_prots('beforeSend', pary, afor, '', tobj);
			},
			success: function(rtnm){/* 成功後執行 */
				if(isck_OBJECT(pary.asuc)) csweb_ajax_prots('success', pary, afor, rtnm, tobj);
			},
			error: function(rtnm){/* 失敗後執行 */
				if(isck_OBJECT(pary.aerr)) csweb_ajax_prots('error', pary, afor, rtnm, tobj);
			},
			complete: function(rtnm){/* 完成後執行 */
				if(isck_OBJECT(pary.acom)) csweb_ajax_prots('complete', pary, afor, rtnm, tobj);
			}
		});
		if(pary.aytp) $.ajaxSetup({async:true});
		if(isck_OBJECT(pary.alng) && typeof loading_close == 'function') loading_close(pary.alng, [], tobj);
	}else if(type == 'file'){
		if(!isck_ARRAY(pary.file)) return;
		gustr = csweb_ajax_getstr(pary, tobj);pdata = csweb_ajax_poststr('ary', pary, tobj);
		if(isck_OBJECT(pary.alng) && typeof loading_create == 'function') loading_create(pary.alng, [], tobj);
		if(pary.aytp) $.ajaxSetup({async:false});
		for(var i = 0; i < pary.file.length; i++){
			if(!isck_STRING(pary.file[i].name,'Y') || !isck_STRING(pary.file[i].id,'Y') ||
			   $(pary.file[i].id).length <= 0) continue;
			for(var j = 0; j < $(pary.file[i].id).length; j++){
				if($(pary.file[i].id)[j].files.length <= 0) continue;
				for(var k = 0; k < $(pary.file[i].id)[j].files.length; k++){
					fdata = pdata;afor = [i,j,k];fdata.append(pary.file[i].name,$(pary.file[i].id)[j].files[k]);
					if(isck_OBJECT(pary.slng) && typeof loading_create == 'function') loading_create(pary.slng, afor, tobj);
					$.ajax({
						url: gustr, type: 'post', data: fdata, processData: false, contentType: false,
						beforeSend: function(){/* 開始前執行 */
							if(isck_OBJECT(pary.abef)) csweb_ajax_prots('beforeSend', pary, afor, '', tobj);
						},
						success: function(rtnm){/* 成功後執行 */
							if(isck_OBJECT(pary.asuc)) csweb_ajax_prots('success', pary, afor, rtnm, tobj);
						},
						error: function(rtnm){/* 失敗後執行 */
							if(isck_OBJECT(pary.aerr)) csweb_ajax_prots('error', pary, afor, rtnm, tobj);
						},
						complete: function(rtnm){/* 完成後執行 */
							if(isck_OBJECT(pary.acom)) csweb_ajax_prots('complete', pary, afor, rtnm, tobj);
						}
					});
					if(isck_OBJECT(pary.slng) && typeof loading_close == 'function') loading_close(pary.slng, afor, tobj);
				}
			}
		}
		if(pary.aytp) $.ajaxSetup({async:true});
		if(isck_OBJECT(pary.alng) && typeof loading_close == 'function') loading_close(pary.alng, [], tobj);
	}
	return;
}